unit Main;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants, System.StrUtils,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.StdCtrls,
  FMX.ListBox, FMX.Layouts, FMX.Objects, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.UI.Intf, FireDAC.Stan.Def,
  FireDAC.Stan.Pool,
  FireDAC.Phys, FireDAC.Comp.Client, FireDAC.Comp.DataSet,
  FireDAC.Stan.ExprFuncs,
  FireDAC.FMXUI.Wait, FireDAC.Comp.UI, FireDAC.Phys.SQLite, Data.DB,
  System.IOUtils, Xml.xmldom,
  Xml.XMLIntf, Xml.adomxmldom, Xml.XMLDoc, FMX.Platform.Android, FMX.Memo;

type
  TForm2 = class(TForm)
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    ComboBox4: TComboBox;
    ListBox1: TListBox;
    ComboBox5: TComboBox;
    ListBoxItem1: TListBoxItem;
    ListBoxItem2: TListBoxItem;
    ListBoxItem3: TListBoxItem;
    ListBoxItem4: TListBoxItem;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ListBoxHeader1: TListBoxHeader;
    Label1: TLabel;
    DBConnection: TFDConnection;
    SQLQuery: TFDQuery;
    Label2: TLabel;
    Button4: TButton;
    AniIndicator1: TAniIndicator;
    ComboBox6: TComboBox;
    Line2: TLine;
    SQLQuery2: TFDQuery;

    procedure Button1Click(Sender: TObject);
    procedure ListBox1ItemClick(const Sender: TCustomListBox;
      const AItem: TListBoxItem);
    procedure LoadLHC(DataPath: String);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure OnSelectDir(const S: string);
    procedure Button4Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);

  private
    DBPath, firstODD, firstDIL, firstPOR, firstPS: String;
    procedure LoadODD;
    procedure LoadDIL(oddeleni: String);
    procedure LoadPOR(dilec: String);
    procedure LoadPS(porost: String);
    procedure LoadEtaz(skupina: String);
    procedure zobrazHK(LHC, rok, oddeleni, dilec, porost, skupina,
      etaz: String);
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

uses
  HK, t_xFileDialog;

{$R *.fmx}

// zobrazeni vyberu slozky
procedure TForm2.Button1Click(Sender: TObject);
begin

  XFileDialog.Directory := '/';
  XFileDialog.ed_Caption.Text := 'Vbr sloky s daty';
  XFileDialog.OnSelect := OnSelectDir;
  XFileDialog.DirsOnly := true;
  XFileDialog.Show;

end;

// vyber adresare s daty
procedure TForm2.OnSelectDir(const S: string);
var
  HomePath: String;
  FileStream: TFileStream;
  RootNode, CurNode: IXMLNODE;
  XMLDocument: IXMLDocument;
begin

  DBPath := S;
  HomePath := TPath.GetHomePath + '/miniHeletaxConf.xml';
  // Label2.Text := HomePath;
  if not TFile.Exists(HomePath) then
  begin
    // TFile.Create(HomePath);
    // XMLDocument.Create(HomePath);
    XMLDocument := NewXMLDocument;
    XMLDocument.Active := true;
    XMLDocument.Encoding := 'utf-8';
    XMLDocument.Options := [doNodeAutoIndent];
    RootNode := XMLDocument.AddChild('root');
    CurNode := RootNode.AddChild('DBPath');
    CurNode.Text := DBPath;
    XMLDocument.SaveToFile(HomePath);
    XMLDocument.Active := false;
  end
  else
  begin
    XMLDocument := LoadXMLDocument(HomePath);
    XMLDocument.Active := true;
    RootNode := XMLDocument.DocumentElement;
    CurNode := RootNode.ChildNodes['DBPath'];
    CurNode.Text := DBPath;
    XMLDocument.SaveToFile(HomePath);
    XMLDocument.Active := false;
  end;
  Application.ProcessMessages;
  LoadLHC(DBPath);
end;

// datasnap pro zobrazeni HK
procedure TForm2.zobrazHK(LHC, rok, oddeleni, dilec, porost, skupina,
  etaz: String);
var
  oddeleniID, dilecID, porostID, skupinaID, etazID: String;
  i, x, etazZast: integer;
  zasoba1, souse, zasobaC, TVP, TVO, TOP, TOO, prorezavkyP, zalProc,
    zalP: Double;
  rect: TRectangle;
  oH: single;
begin

  (*
    oH := HospKniha.ScaledLayout1.OriginalHeight;
    for i := 1 to 25 do
    begin
    rect := TRectangle.Create(HospKniha.ScaledLayout1);
    rect.Width := HospKniha.Rectangle38.Width;
    rect.Height := HospKniha.Rectangle38.Height;
    rect.Name := 'r'+i.ToString;
    rect.Position.X := HospKniha.Rectangle38.Position.X;
    rect.Position.Y := HospKniha.Rectangle38.Position.Y + 32*i;
    //rect.Parent := HospKniha.ScaledLayout1;
    HospKniha.ScaledLayout1.AddObject(rect);
    HospKniha.Height := HospKniha.Height + 33;
    HospKniha.ScaledLayout1.OriginalHeight := HospKniha.ScaledLayout1.OriginalHeight + 33;
    HospKniha.ScaledLayout1.Height := HospKniha.ScaledLayout1.Height + 33;
    end;
  *)

  DBConnection.Params.Values['Database'] := DBPath + '/LHC_' + LHC + '_' + rok
    + '.s3db';

  // Memo1.Lines.Add(LHC);
  // Memo1.Lines.Add(rok);
  // Memo1.Lines.Add(oddeleni);
  // Memo1.Lines.Add(dilec);
  // Memo1.Lines.Add(porost);
  // Memo1.Lines.Add(skupina);

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from oddeleni WHERE ODD = ' + oddeleni);
  SQLQuery.OpenOrExecute;
  oddeleniID := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from dilec WHERE DIL = "' + dilec +
    '" AND VAZBA = ' + oddeleniID);
  SQLQuery.OpenOrExecute;
  dilecID := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from porost WHERE POR = "' + porost +
    '" AND VAZBA = ' + dilecID);
  SQLQuery.OpenOrExecute;
  porostID := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from ps WHERE PSK = "' + skupina +
    '" AND VAZBA = ' + porostID);
  SQLQuery.OpenOrExecute;
  skupinaID := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from etaz WHERE ETAZ = "' + etaz +
    '" AND VAZBA = ' + skupinaID);
  SQLQuery.OpenOrExecute;
  etazID := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  (*
    for I := 0 to HospKniha.ScaledLayout1.ChildrenCount do
    begin
    if HospKniha.ScaledLayout1.Children.Items[I].ClassName.Equals('TLabel') then
    begin
    TLabel(HospKniha.ScaledLayout1.Children.Items[I]).Text := '';
    end
    else if HospKniha.ScaledLayout1.Children.Items[I].ClassName.Equals('TRectangle') then
    begin
    for X := 0 to HospKniha.ScaledLayout1.Children.Items[I].ChildrenCount do
    begin
    TLabel(HospKniha.ScaledLayout1.Children.Items[I].Children.Items[X]).Text := '';
    end;
    end;
    end;
  *)

  HospKniha.Label8.Text := '';
  HospKniha.Label24.Text := '';
  HospKniha.Label26.Text := '';
  HospKniha.Label28.Text := '';
  HospKniha.Label32.Text := '';
  HospKniha.Label271.Text := '';
  HospKniha.Label48.Text := '';
  HospKniha.Label30.Text := '';
  HospKniha.Label11.Text := '';
  HospKniha.Label2.Text := '';
  HospKniha.Label6.Text := '';
  HospKniha.Label10.Text := '';
  HospKniha.Label4.Text := '';
  HospKniha.Label14.Text := '';
  HospKniha.Label16.Text := '';
  HospKniha.Label18.Text := '';
  HospKniha.Label20.Text := '';
  HospKniha.Label22.Text := '';
  HospKniha.Label36.Text := '';
  HospKniha.Label38.Text := '';
  HospKniha.Label42.Text := '';
  HospKniha.Label44.Text := '';
  HospKniha.Label46.Text := '';
  HospKniha.Label40.Text := '';
  HospKniha.Label34.Text := '';
  HospKniha.Label54.Text := '';
  HospKniha.Label92.Text := '';
  HospKniha.Label93.Text := '';
  HospKniha.Label94.Text := '';
  HospKniha.Label273.Text := '';
  HospKniha.Label275.Text := '';
  HospKniha.Label56.Text := '';
  HospKniha.Label102.Text := '';
  HospKniha.Label109.Text := '';
  HospKniha.Label122.Text := '';
  HospKniha.Label136.Text := '';
  HospKniha.Label143.Text := '';
  HospKniha.Label171.Text := '';

  HospKniha.Label150.Text := '';
  HospKniha.Label178.Text := '';

  HospKniha.Label185.Text := '';

  HospKniha.Label192.Text := '';
  HospKniha.Label157.Text := '';
  HospKniha.Label164.Text := '';

  HospKniha.Label220.Text := '';
  HospKniha.Label227.Text := '';
  HospKniha.Label199.Text := '';
  HospKniha.Label206.Text := '';
  HospKniha.Label213.Text := '';

  HospKniha.Label248.Text := '';
  HospKniha.Label255.Text := '';
  HospKniha.Label262.Text := '';
  HospKniha.Label269.Text := '';

  HospKniha.Label96.Text := '';
  HospKniha.Label103.Text := '';
  HospKniha.Label110.Text := '';
  HospKniha.Label121.Text := '';
  HospKniha.Label135.Text := '';
  HospKniha.Label142.Text := '';
  HospKniha.Label170.Text := '';

  HospKniha.Label149.Text := '';
  HospKniha.Label177.Text := '';
  HospKniha.Label184.Text := '';
  HospKniha.Label191.Text := '';

  HospKniha.Label156.Text := '';
  HospKniha.Label163.Text := '';

  HospKniha.Label219.Text := '';
  HospKniha.Label226.Text := '';

  HospKniha.Label198.Text := '';
  HospKniha.Label205.Text := '';
  HospKniha.Label212.Text := '';

  HospKniha.Label247.Text := '';
  HospKniha.Label254.Text := '';
  HospKniha.Label261.Text := '';
  HospKniha.Label268.Text := '';
  HospKniha.Label97.Text := '';
  HospKniha.Label104.Text := '';
  HospKniha.Label111.Text := '';
  HospKniha.Label120.Text := '';
  HospKniha.Label134.Text := '';
  HospKniha.Label141.Text := '';
  HospKniha.Label169.Text := '';

  HospKniha.Label148.Text := '';
  HospKniha.Label176.Text := '';
  HospKniha.Label183.Text := '';
  HospKniha.Label190.Text := '';

  HospKniha.Label155.Text := '';
  HospKniha.Label162.Text := '';

  HospKniha.Label218.Text := '';
  HospKniha.Label225.Text := '';

  HospKniha.Label197.Text := '';
  HospKniha.Label204.Text := '';
  HospKniha.Label211.Text := '';

  HospKniha.Label246.Text := '';
  HospKniha.Label253.Text := '';
  HospKniha.Label260.Text := '';
  HospKniha.Label267.Text := '';

  HospKniha.Label98.Text := '';
  HospKniha.Label105.Text := '';
  HospKniha.Label112.Text := '';
  HospKniha.Label119.Text := '';
  HospKniha.Label133.Text := '';
  HospKniha.Label140.Text := '';
  HospKniha.Label168.Text := '';

  HospKniha.Label147.Text := '';
  HospKniha.Label175.Text := '';
  HospKniha.Label182.Text := '';
  HospKniha.Label189.Text := '';

  HospKniha.Label154.Text := '';
  HospKniha.Label161.Text := '';

  HospKniha.Label217.Text := '';
  HospKniha.Label224.Text := '';

  HospKniha.Label196.Text := '';
  HospKniha.Label203.Text := '';
  HospKniha.Label210.Text := '';

  HospKniha.Label245.Text := '';
  HospKniha.Label252.Text := '';
  HospKniha.Label259.Text := '';
  HospKniha.Label266.Text := '';

  HospKniha.Label99.Text := '';
  HospKniha.Label106.Text := '';
  HospKniha.Label113.Text := '';
  HospKniha.Label118.Text := '';
  HospKniha.Label132.Text := '';
  HospKniha.Label139.Text := '';
  HospKniha.Label167.Text := '';

  HospKniha.Label146.Text := '';
  HospKniha.Label174.Text := '';
  HospKniha.Label181.Text := '';
  HospKniha.Label188.Text := '';

  HospKniha.Label153.Text := '';
  HospKniha.Label160.Text := '';

  HospKniha.Label216.Text := '';
  HospKniha.Label223.Text := '';

  HospKniha.Label195.Text := '';
  HospKniha.Label202.Text := '';
  HospKniha.Label209.Text := '';

  HospKniha.Label244.Text := '';
  HospKniha.Label251.Text := '';
  HospKniha.Label258.Text := '';
  HospKniha.Label265.Text := '';

  HospKniha.Label100.Text := '';
  HospKniha.Label107.Text := '';
  HospKniha.Label114.Text := '';
  HospKniha.Label116.Text := '';
  HospKniha.Label130.Text := '';
  HospKniha.Label137.Text := '';
  HospKniha.Label165.Text := '';

  HospKniha.Label144.Text := '';
  HospKniha.Label172.Text := '';
  HospKniha.Label179.Text := '';
  HospKniha.Label186.Text := '';

  HospKniha.Label151.Text := '';
  HospKniha.Label158.Text := '';

  HospKniha.Label214.Text := '';
  HospKniha.Label221.Text := '';

  HospKniha.Label193.Text := '';
  HospKniha.Label200.Text := '';
  HospKniha.Label207.Text := '';

  HospKniha.Label242.Text := '';
  HospKniha.Label249.Text := '';
  HospKniha.Label256.Text := '';
  HospKniha.Label263.Text := '';

  HospKniha.Label108.Text := '';
  HospKniha.Label173.Text := '';
  HospKniha.Label180.Text := '';
  HospKniha.Label187.Text := '';
  HospKniha.Label201.Text := '';
  HospKniha.Label208.Text := '';
  HospKniha.Label215.Text := '';
  HospKniha.Label222.Text := '';
  HospKniha.Label257.Text := '';
  HospKniha.Label264.Text := '';

  HospKniha.Label234.Text := '';
  HospKniha.Label241.Text := '';
  HospKniha.Label233.Text := '';
  HospKniha.Label240.Text := '';
  HospKniha.Label232.Text := '';
  HospKniha.Label239.Text := '';
  HospKniha.Label231.Text := '';
  HospKniha.Label238.Text := '';
  HospKniha.Label230.Text := '';
  HospKniha.Label237.Text := '';
  HospKniha.Label228.Text := '';
  HospKniha.Label235.Text := '';

  HospKniha.Label236.Text := '';
  HospKniha.Label14.Text := '';
  HospKniha.Label16.Text := '';
  HospKniha.Label18.Text := '';
  HospKniha.Label2.Text := '';
  HospKniha.Label6.Text := '';
  HospKniha.Label40.Text := '';
  HospKniha.Label4.Text := '';
  HospKniha.Label46.Text := '';

  HospKniha.Label8.Text := LHC;
  HospKniha.Label24.Text := oddeleni;
  HospKniha.Label26.Text := dilec;
  HospKniha.Label28.Text := porost;
  HospKniha.Label32.Text := skupina;
  HospKniha.Label271.Text := etaz;

  // Memo1.Lines.Add(oddeleniID);
  // Memo1.Lines.Add(dilecID);
  // Memo1.Lines.Add(porostID);
  // Memo1.Lines.Add(skupinaID);

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT Poznamka from ps_pozn WHERE Vazba = ' + skupinaID);
  SQLQuery.OpenOrExecute;
  if not SQLQuery.FieldByName('Poznamka').IsNull then
    HospKniha.Label48.Text := SQLQuery.FieldByName('Poznamka').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT POZNAMKA from por_pozn WHERE VAZBA = ' + porostID);
  SQLQuery.OpenOrExecute;
  if not SQLQuery.FieldByName('POZNAMKA').IsNull then
    HospKniha.Label30.Text := SQLQuery.FieldByName('POZNAMKA').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from lhc WHERE LHC_KOD = ' + LHC);
  SQLQuery.OpenOrExecute;
  HospKniha.Label11.Text := SQLQuery.FieldByName('LHP_OD').AsString + ' - ' +
    SQLQuery.FieldByName('LHP_DO').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from porost WHERE ID = ' + porostID);
  SQLQuery.OpenOrExecute;
  HospKniha.Label2.Text := SQLQuery.FieldByName('LES_OBL').AsString;
  HospKniha.Label6.Text := SQLQuery.FieldByName('ZVL_STATUS').AsString;
  HospKniha.Label10.Text := SQLQuery.FieldByName('PAS_OHR').AsString;
  HospKniha.Label4.Text := SQLQuery.FieldByName('KATEGORIE').AsString;
  HospKniha.Label14.Text := SQLQuery.FieldByName('ORG_UROVEN1').AsString;
  HospKniha.Label16.Text := SQLQuery.FieldByName('ORG_UROVEN2').AsString;
  HospKniha.Label18.Text := SQLQuery.FieldByName('ORG_UROVEN3').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add
    ('SELECT ROUND(SUM(PSK_P),2) as suma FROM ps WHERE VAZBA IN (SELECT ID FROM porost WHERE VAZBA IN (SELECT ID FROM dilec WHERE VAZBA = '
    + oddeleniID + '))');
  SQLQuery.OpenOrExecute;
  HospKniha.Label20.Text := SQLQuery.FieldByName('suma').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ROUND(SUM(PSK_P),2) as suma  FROM ps WHERE VAZBA =  '
    + porostID);
  SQLQuery.OpenOrExecute;
  HospKniha.Label22.Text := SQLQuery.FieldByName('suma').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from ps WHERE ID = ' + skupinaID);
  SQLQuery.OpenOrExecute;
  HospKniha.Label36.Text := SQLQuery.FieldByName('LT').AsString;
  HospKniha.Label38.Text := SQLQuery.FieldByName('LVS').AsString;
  HospKniha.Label42.Text := SQLQuery.FieldByName('TER_TYP').AsString;
  HospKniha.Label44.Text := SQLQuery.FieldByName('Terenni_skupina').AsString;
  HospKniha.Label46.Text := SQLQuery.FieldByName('KU_KOD').AsString;
  HospKniha.Label40.Text := SQLQuery.FieldByName('LES_URAD').AsString;
  HospKniha.Label34.Text := SQLQuery.FieldByName('PSK_P').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from etaz WHERE ID = ' + etazID);
  SQLQuery.OpenOrExecute;
  HospKniha.Label54.Text := SQLQuery.FieldByName('OBMYTI').AsString + '/' +
    SQLQuery.FieldByName('OBN_DOBA').AsString;
  HospKniha.Label92.Text := SQLQuery.FieldByName('HS').AsString;
  HospKniha.Label93.Text := SQLQuery.FieldByName('VEK').AsString;
  HospKniha.Label94.Text := SQLQuery.FieldByName('ZAKM').AsString;
  HospKniha.Label273.Text := SQLQuery.FieldByName('ETAZ_PP').AsString;
  HospKniha.Label275.Text := SQLQuery.FieldByName('ETAZ_PS').AsString;
  HospKniha.Label56.Text := SQLQuery.FieldByName('MZD').AsString;

  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from drevina WHERE VAZBA = ' + etazID);
  SQLQuery.OpenOrExecute;
  i := 0;
  etazZast := 0;
  zasoba1 := 0;
  souse := 0;
  zasobaC := 0;
  TVP := 0;
  TVO := 0;
  TOP := 0;
  TOO := 0;
  prorezavkyP := 0;
  zalProc := 0;
  zalP := 0;
  while NOT SQLQuery.Eof do
  begin
    case i of
      0:
        begin
          zasoba1 := zasoba1 + SQLQuery.FieldByName('DR_ZAS_HA').AsFloat;
          souse := souse + SQLQuery.FieldByName('PROC_SOUS').AsFloat;
          zasobaC := zasobaC + SQLQuery.FieldByName('DR_ZAS_CELK').AsFloat;

          HospKniha.Label95.Text := SQLQuery.FieldByName('DR_ZKR').AsString;
          HospKniha.Label102.Text := SQLQuery.FieldByName('ZAST').AsString;
          HospKniha.Label109.Text := SQLQuery.FieldByName('TLOUSTKA').AsString;
          HospKniha.Label122.Text := SQLQuery.FieldByName('VYSKA').AsString;
          HospKniha.Label136.Text := SQLQuery.FieldByName('BON_A').AsString;
          HospKniha.Label143.Text := SQLQuery.FieldByName('BON_R').AsString;
          HospKniha.Label171.Text := SQLQuery.FieldByName('IMISE').AsString;
          etazZast := etazZast + SQLQuery.FieldByName('ZAST').AsInteger;

          HospKniha.Label150.Text := SQLQuery.FieldByName('GEN_KLAS').AsString;
          HospKniha.Label178.Text := SQLQuery.FieldByName('DR_ZAS_HA').AsString;

          HospKniha.Label185.Text := SQLQuery.FieldByName('PROC_SOUS').AsString;

          HospKniha.Label192.Text :=
            SQLQuery.FieldByName('DR_ZAS_CELK').AsString;

          // HospKniha.Label199.Text := SQLQuery.FieldByName('DR_ZAS_CELK').AsString;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from poskoz WHERE Vazba = ' +
            SQLQuery.FieldByName('ID').AsString);
          SQLQuery2.OpenOrExecute;
          HospKniha.Label157.Text := SQLQuery2.FieldByName
            ('Druh_poskozeni').AsString;
          HospKniha.Label164.Text := SQLQuery2.FieldByName
            ('Stupen_poskozeni').AsString;
          SQLQuery2.Close;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from navrh WHERE Vazba = ' + etazID +
            ' AND N_Zkratka_dreviny = "' + HospKniha.Label95.Text + '"');
          SQLQuery2.OpenOrExecute;

          case SQLQuery2.FieldByName('N_Druh_vykonu').AsInteger of
            10:
              begin
                TOP := TOP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TOO := TOO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label220.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label227.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            11:
              begin
                TVP := TVP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TVO := TVO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label199.Text :=
                  SQLQuery2.FieldByName('N_Nalehavost').AsString;
                HospKniha.Label206.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label213.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            1, 2, 3, 4, 5, 6, 7:
              begin
                zalProc := zalProc + SQLQuery2.FieldByName
                  ('N_Procento').AsFloat;
                zalP := zalP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                HospKniha.Label248.Text :=
                  SQLQuery2.FieldByName('N_Druh_vykonu').AsString;
                HospKniha.Label255.Text :=
                  SQLQuery2.FieldByName('N_Zkratka_dreviny').AsString;
                HospKniha.Label262.Text :=
                  SQLQuery2.FieldByName('N_Procento').AsString;
                HospKniha.Label269.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
              end;
          else
            begin

            end;
          end;

          SQLQuery2.Close;

        end;
      1:
        begin
          zasoba1 := zasoba1 + SQLQuery.FieldByName('DR_ZAS_HA').AsFloat;
          souse := souse + SQLQuery.FieldByName('PROC_SOUS').AsFloat;
          zasobaC := zasobaC + SQLQuery.FieldByName('DR_ZAS_CELK').AsFloat;
          HospKniha.Label96.Text := SQLQuery.FieldByName('DR_ZKR').AsString;
          HospKniha.Label103.Text := SQLQuery.FieldByName('ZAST').AsString;
          HospKniha.Label110.Text := SQLQuery.FieldByName('TLOUSTKA').AsString;
          HospKniha.Label121.Text := SQLQuery.FieldByName('VYSKA').AsString;
          HospKniha.Label135.Text := SQLQuery.FieldByName('BON_A').AsString;
          HospKniha.Label142.Text := SQLQuery.FieldByName('BON_R').AsString;
          HospKniha.Label170.Text := SQLQuery.FieldByName('IMISE').AsString;
          etazZast := etazZast + SQLQuery.FieldByName('ZAST').AsInteger;

          HospKniha.Label149.Text := SQLQuery.FieldByName('GEN_KLAS').AsString;
          HospKniha.Label177.Text := SQLQuery.FieldByName('DR_ZAS_HA').AsString;
          HospKniha.Label184.Text := SQLQuery.FieldByName('PROC_SOUS').AsString;
          HospKniha.Label191.Text :=
            SQLQuery.FieldByName('DR_ZAS_CELK').AsString;
          // HospKniha.Label199.Text := SQLQuery.FieldByName('DR_ZAS_CELK').AsString;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from poskoz WHERE Vazba = ' +
            SQLQuery.FieldByName('ID').AsString);
          SQLQuery2.OpenOrExecute;
          HospKniha.Label156.Text := SQLQuery2.FieldByName
            ('Druh_poskozeni').AsString;
          HospKniha.Label163.Text := SQLQuery2.FieldByName
            ('Stupen_poskozeni').AsString;
          SQLQuery2.Close;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from navrh WHERE Vazba = ' + etazID +
            ' AND N_Zkratka_dreviny = "' + HospKniha.Label95.Text + '"');
          SQLQuery2.OpenOrExecute;

          case SQLQuery2.FieldByName('N_Druh_vykonu').AsInteger of
            10:
              begin
                TOP := TOP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TOO := TOO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label219.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label226.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            11:
              begin
                TVP := TVP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TVO := TVO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label198.Text :=
                  SQLQuery2.FieldByName('N_Nalehavost').AsString;
                HospKniha.Label205.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label212.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            1, 2, 3, 4, 5, 6, 7:
              begin
                zalProc := zalProc + SQLQuery2.FieldByName
                  ('N_Procento').AsFloat;
                zalP := zalP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                HospKniha.Label247.Text :=
                  SQLQuery2.FieldByName('N_Druh_vykonu').AsString;
                HospKniha.Label254.Text :=
                  SQLQuery2.FieldByName('N_Zkratka_dreviny').AsString;
                HospKniha.Label261.Text :=
                  SQLQuery2.FieldByName('N_Procento').AsString;
                HospKniha.Label268.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
              end;
          else
            begin

            end;
          end;

          SQLQuery2.Close;

        end;
      2:
        begin
          zasoba1 := zasoba1 + SQLQuery.FieldByName('DR_ZAS_HA').AsFloat;
          souse := souse + SQLQuery.FieldByName('PROC_SOUS').AsFloat;
          zasobaC := zasobaC + SQLQuery.FieldByName('DR_ZAS_CELK').AsFloat;
          HospKniha.Label97.Text := SQLQuery.FieldByName('DR_ZKR').AsString;
          HospKniha.Label104.Text := SQLQuery.FieldByName('ZAST').AsString;
          HospKniha.Label111.Text := SQLQuery.FieldByName('TLOUSTKA').AsString;
          HospKniha.Label120.Text := SQLQuery.FieldByName('VYSKA').AsString;
          HospKniha.Label134.Text := SQLQuery.FieldByName('BON_A').AsString;
          HospKniha.Label141.Text := SQLQuery.FieldByName('BON_R').AsString;
          HospKniha.Label169.Text := SQLQuery.FieldByName('IMISE').AsString;
          etazZast := etazZast + SQLQuery.FieldByName('ZAST').AsInteger;

          HospKniha.Label148.Text := SQLQuery.FieldByName('GEN_KLAS').AsString;
          HospKniha.Label176.Text := SQLQuery.FieldByName('DR_ZAS_HA').AsString;
          HospKniha.Label183.Text := SQLQuery.FieldByName('PROC_SOUS').AsString;
          HospKniha.Label190.Text :=
            SQLQuery.FieldByName('DR_ZAS_CELK').AsString;
          // HospKniha.Label199.Text := SQLQuery.FieldByName('DR_ZAS_CELK').AsString;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from poskoz WHERE Vazba = ' +
            SQLQuery.FieldByName('ID').AsString);
          SQLQuery2.OpenOrExecute;
          HospKniha.Label155.Text := SQLQuery2.FieldByName
            ('Druh_poskozeni').AsString;
          HospKniha.Label162.Text := SQLQuery2.FieldByName
            ('Stupen_poskozeni').AsString;
          SQLQuery2.Close;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from navrh WHERE Vazba = ' + etazID +
            ' AND N_Zkratka_dreviny = "' + HospKniha.Label95.Text + '"');
          SQLQuery2.OpenOrExecute;

          case SQLQuery2.FieldByName('N_Druh_vykonu').AsInteger of
            10:
              begin
                TOP := TOP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TOO := TOO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label218.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label225.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            11:
              begin
                TVP := TVP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TVO := TVO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label197.Text :=
                  SQLQuery2.FieldByName('N_Nalehavost').AsString;
                HospKniha.Label204.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label211.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            1, 2, 3, 4, 5, 6, 7:
              begin
                zalProc := zalProc + SQLQuery2.FieldByName
                  ('N_Procento').AsFloat;
                zalP := zalP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                HospKniha.Label246.Text :=
                  SQLQuery2.FieldByName('N_Druh_vykonu').AsString;
                HospKniha.Label253.Text :=
                  SQLQuery2.FieldByName('N_Zkratka_dreviny').AsString;
                HospKniha.Label260.Text :=
                  SQLQuery2.FieldByName('N_Procento').AsString;
                HospKniha.Label267.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
              end;
          else
            begin

            end;
          end;

          SQLQuery2.Close;

        end;
      3:
        begin
          zasoba1 := zasoba1 + SQLQuery.FieldByName('DR_ZAS_HA').AsFloat;
          souse := souse + SQLQuery.FieldByName('PROC_SOUS').AsFloat;
          zasobaC := zasobaC + SQLQuery.FieldByName('DR_ZAS_CELK').AsFloat;
          HospKniha.Label98.Text := SQLQuery.FieldByName('DR_ZKR').AsString;
          HospKniha.Label105.Text := SQLQuery.FieldByName('ZAST').AsString;
          HospKniha.Label112.Text := SQLQuery.FieldByName('TLOUSTKA').AsString;
          HospKniha.Label119.Text := SQLQuery.FieldByName('VYSKA').AsString;
          HospKniha.Label133.Text := SQLQuery.FieldByName('BON_A').AsString;
          HospKniha.Label140.Text := SQLQuery.FieldByName('BON_R').AsString;
          HospKniha.Label168.Text := SQLQuery.FieldByName('IMISE').AsString;
          etazZast := etazZast + SQLQuery.FieldByName('ZAST').AsInteger;

          HospKniha.Label147.Text := SQLQuery.FieldByName('GEN_KLAS').AsString;
          HospKniha.Label175.Text := SQLQuery.FieldByName('DR_ZAS_HA').AsString;
          HospKniha.Label182.Text := SQLQuery.FieldByName('PROC_SOUS').AsString;
          HospKniha.Label189.Text :=
            SQLQuery.FieldByName('DR_ZAS_CELK').AsString;
          // HospKniha.Label199.Text := SQLQuery.FieldByName('DR_ZAS_CELK').AsString;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from poskoz WHERE Vazba = ' +
            SQLQuery.FieldByName('ID').AsString);
          SQLQuery2.OpenOrExecute;
          HospKniha.Label154.Text := SQLQuery2.FieldByName
            ('Druh_poskozeni').AsString;
          HospKniha.Label161.Text := SQLQuery2.FieldByName
            ('Stupen_poskozeni').AsString;
          SQLQuery2.Close;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from navrh WHERE Vazba = ' + etazID +
            ' AND N_Zkratka_dreviny = "' + HospKniha.Label95.Text + '"');
          SQLQuery2.OpenOrExecute;

          case SQLQuery2.FieldByName('N_Druh_vykonu').AsInteger of
            10:
              begin
                TOP := TOP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TOO := TOO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label217.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label224.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            11:
              begin
                TVP := TVP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TVO := TVO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label196.Text :=
                  SQLQuery2.FieldByName('N_Nalehavost').AsString;
                HospKniha.Label203.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label210.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            1, 2, 3, 4, 5, 6, 7:
              begin
                zalProc := zalProc + SQLQuery2.FieldByName
                  ('N_Procento').AsFloat;
                zalP := zalP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                HospKniha.Label245.Text :=
                  SQLQuery2.FieldByName('N_Druh_vykonu').AsString;
                HospKniha.Label252.Text :=
                  SQLQuery2.FieldByName('N_Zkratka_dreviny').AsString;
                HospKniha.Label259.Text :=
                  SQLQuery2.FieldByName('N_Procento').AsString;
                HospKniha.Label266.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
              end;
          else
            begin

            end;
          end;

          SQLQuery2.Close;

        end;
      4:
        begin
          zasoba1 := zasoba1 + SQLQuery.FieldByName('DR_ZAS_HA').AsFloat;
          souse := souse + SQLQuery.FieldByName('PROC_SOUS').AsFloat;
          zasobaC := zasobaC + SQLQuery.FieldByName('DR_ZAS_CELK').AsFloat;
          HospKniha.Label99.Text := SQLQuery.FieldByName('DR_ZKR').AsString;
          HospKniha.Label106.Text := SQLQuery.FieldByName('ZAST').AsString;
          HospKniha.Label113.Text := SQLQuery.FieldByName('TLOUSTKA').AsString;
          HospKniha.Label118.Text := SQLQuery.FieldByName('VYSKA').AsString;
          HospKniha.Label132.Text := SQLQuery.FieldByName('BON_A').AsString;
          HospKniha.Label139.Text := SQLQuery.FieldByName('BON_R').AsString;
          HospKniha.Label167.Text := SQLQuery.FieldByName('IMISE').AsString;
          etazZast := etazZast + SQLQuery.FieldByName('ZAST').AsInteger;

          HospKniha.Label146.Text := SQLQuery.FieldByName('GEN_KLAS').AsString;
          HospKniha.Label174.Text := SQLQuery.FieldByName('DR_ZAS_HA').AsString;
          HospKniha.Label181.Text := SQLQuery.FieldByName('PROC_SOUS').AsString;
          HospKniha.Label188.Text :=
            SQLQuery.FieldByName('DR_ZAS_CELK').AsString;
          // HospKniha.Label199.Text := SQLQuery.FieldByName('DR_ZAS_CELK').AsString;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from poskoz WHERE Vazba = ' +
            SQLQuery.FieldByName('ID').AsString);
          SQLQuery2.OpenOrExecute;
          HospKniha.Label153.Text := SQLQuery2.FieldByName
            ('Druh_poskozeni').AsString;
          HospKniha.Label160.Text := SQLQuery2.FieldByName
            ('Stupen_poskozeni').AsString;
          SQLQuery2.Close;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from navrh WHERE Vazba = ' + etazID +
            ' AND N_Zkratka_dreviny = "' + HospKniha.Label95.Text + '"');
          SQLQuery2.OpenOrExecute;

          case SQLQuery2.FieldByName('N_Druh_vykonu').AsInteger of
            10:
              begin
                TOP := TOP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TOO := TOO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label216.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label223.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            11:
              begin
                TVP := TVP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TVO := TVO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label195.Text :=
                  SQLQuery2.FieldByName('N_Nalehavost').AsString;
                HospKniha.Label202.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label209.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            1, 2, 3, 4, 5, 6, 7:
              begin
                zalProc := zalProc + SQLQuery2.FieldByName
                  ('N_Procento').AsFloat;
                zalP := zalP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                HospKniha.Label244.Text :=
                  SQLQuery2.FieldByName('N_Druh_vykonu').AsString;
                HospKniha.Label251.Text :=
                  SQLQuery2.FieldByName('N_Zkratka_dreviny').AsString;
                HospKniha.Label258.Text :=
                  SQLQuery2.FieldByName('N_Procento').AsString;
                HospKniha.Label265.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
              end;
          else
            begin

            end;
          end;

          SQLQuery2.Close;

        end;
      5:
        begin
          zasoba1 := zasoba1 + SQLQuery.FieldByName('DR_ZAS_HA').AsFloat;
          souse := souse + SQLQuery.FieldByName('PROC_SOUS').AsFloat;
          zasobaC := zasobaC + SQLQuery.FieldByName('DR_ZAS_CELK').AsFloat;
          HospKniha.Label100.Text := SQLQuery.FieldByName('DR_ZKR').AsString;
          HospKniha.Label107.Text := SQLQuery.FieldByName('ZAST').AsString;
          HospKniha.Label114.Text := SQLQuery.FieldByName('TLOUSTKA').AsString;
          HospKniha.Label116.Text := SQLQuery.FieldByName('VYSKA').AsString;
          HospKniha.Label130.Text := SQLQuery.FieldByName('BON_A').AsString;
          HospKniha.Label137.Text := SQLQuery.FieldByName('BON_R').AsString;
          HospKniha.Label165.Text := SQLQuery.FieldByName('IMISE').AsString;
          etazZast := etazZast + SQLQuery.FieldByName('ZAST').AsInteger;

          HospKniha.Label144.Text := SQLQuery.FieldByName('GEN_KLAS').AsString;
          HospKniha.Label172.Text := SQLQuery.FieldByName('DR_ZAS_HA').AsString;
          HospKniha.Label179.Text := SQLQuery.FieldByName('PROC_SOUS').AsString;
          HospKniha.Label186.Text :=
            SQLQuery.FieldByName('DR_ZAS_CELK').AsString;
          // HospKniha.Label199.Text := SQLQuery.FieldByName('DR_ZAS_CELK').AsString;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from poskoz WHERE Vazba = ' +
            SQLQuery.FieldByName('ID').AsString);
          SQLQuery2.OpenOrExecute;
          HospKniha.Label151.Text := SQLQuery2.FieldByName
            ('Druh_poskozeni').AsString;
          HospKniha.Label158.Text := SQLQuery2.FieldByName
            ('Stupen_poskozeni').AsString;
          SQLQuery2.Close;

          SQLQuery2.SQL.Clear;
          SQLQuery2.SQL.Add('SELECT * from navrh WHERE Vazba = ' + etazID +
            ' AND N_Zkratka_dreviny = "' + HospKniha.Label95.Text + '"');
          SQLQuery2.OpenOrExecute;

          case SQLQuery2.FieldByName('N_Druh_vykonu').AsInteger of
            10:
              begin
                TOP := TOP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TOO := TOO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label214.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label221.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            11:
              begin
                TVP := TVP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                TVO := TVO + SQLQuery2.FieldByName('N_Objem').AsFloat;
                HospKniha.Label193.Text :=
                  SQLQuery2.FieldByName('N_Nalehavost').AsString;
                HospKniha.Label200.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
                HospKniha.Label207.Text :=
                  SQLQuery2.FieldByName('N_Objem').AsString;
              end;
            1, 2, 3, 4, 5, 6, 7:
              begin
                zalProc := zalProc + SQLQuery2.FieldByName
                  ('N_Procento').AsFloat;
                zalP := zalP + SQLQuery2.FieldByName('N_Plocha').AsFloat;
                HospKniha.Label242.Text :=
                  SQLQuery2.FieldByName('N_Druh_vykonu').AsString;
                HospKniha.Label249.Text :=
                  SQLQuery2.FieldByName('N_Zkratka_dreviny').AsString;
                HospKniha.Label256.Text :=
                  SQLQuery2.FieldByName('N_Procento').AsString;
                HospKniha.Label263.Text :=
                  SQLQuery2.FieldByName('N_Plocha').AsString;
              end;
          else
            begin

            end;
          end;

          SQLQuery2.Close;

        end;
    else
      begin
        break;
      end;

    end;
    SQLQuery.Next;
    Inc(i);
  end;
  SQLQuery.Close;

  HospKniha.Label108.Text := FloatToStr(etazZast);
  HospKniha.Label173.Text := FloatToStr(zasoba1);
  HospKniha.Label180.Text := FloatToStr(souse);
  HospKniha.Label187.Text := FloatToStr(zasobaC);
  HospKniha.Label201.Text := FloatToStr(TVP);
  HospKniha.Label208.Text := FloatToStr(TVO);
  HospKniha.Label215.Text := FloatToStr(TOP);
  HospKniha.Label222.Text := FloatToStr(TOO);
  HospKniha.Label257.Text := FloatToStr(zalProc);
  HospKniha.Label264.Text := FloatToStr(zalP);

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from navrh WHERE Vazba = ' + etazID +
    ' AND N_Zkratka_dreviny = "000"');
  SQLQuery.OpenOrExecute;
  i := 0;
  while NOT SQLQuery.Eof do
  begin
    case i of
      0:
        begin
          HospKniha.Label234.Text :=
            SQLQuery.FieldByName('N_Nalehavost').AsString;
          HospKniha.Label241.Text := SQLQuery.FieldByName('N_Plocha').AsString;
          prorezavkyP := prorezavkyP + SQLQuery.FieldByName('N_Plocha').AsFloat;
        end;
      1:
        begin
          HospKniha.Label233.Text :=
            SQLQuery.FieldByName('N_Nalehavost').AsString;
          HospKniha.Label240.Text := SQLQuery.FieldByName('N_Plocha').AsString;
          prorezavkyP := prorezavkyP + SQLQuery.FieldByName('N_Plocha').AsFloat;
        end;
      2:
        begin
          HospKniha.Label232.Text :=
            SQLQuery.FieldByName('N_Nalehavost').AsString;
          HospKniha.Label239.Text := SQLQuery.FieldByName('N_Plocha').AsString;
          prorezavkyP := prorezavkyP + SQLQuery.FieldByName('N_Plocha').AsFloat;
        end;
      3:
        begin
          HospKniha.Label231.Text :=
            SQLQuery.FieldByName('N_Nalehavost').AsString;
          HospKniha.Label238.Text := SQLQuery.FieldByName('N_Plocha').AsString;
          prorezavkyP := prorezavkyP + SQLQuery.FieldByName('N_Plocha').AsFloat;
        end;
      4:
        begin
          HospKniha.Label230.Text :=
            SQLQuery.FieldByName('N_Nalehavost').AsString;
          HospKniha.Label237.Text := SQLQuery.FieldByName('N_Plocha').AsString;
          prorezavkyP := prorezavkyP + SQLQuery.FieldByName('N_Plocha').AsFloat;
        end;
      5:
        begin
          HospKniha.Label228.Text :=
            SQLQuery.FieldByName('N_Nalehavost').AsString;
          HospKniha.Label235.Text := SQLQuery.FieldByName('N_Plocha').AsString;
          prorezavkyP := prorezavkyP + SQLQuery.FieldByName('N_Plocha').AsFloat;
        end;
    else
      begin
        break;
      end;
    end;
    SQLQuery.Next;
    Inc(i);
  end;
  SQLQuery.Close;

  HospKniha.Label236.Text := FloatToStr(prorezavkyP);

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from phs_orgur1 WHERE KOD = ' +
    HospKniha.Label14.Text);
  SQLQuery.OpenOrExecute;
  HospKniha.Label14.Text := SQLQuery.FieldByName('POPIS').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from phs_orgur2 WHERE KOD = ' +
    HospKniha.Label16.Text);
  SQLQuery.OpenOrExecute;
  HospKniha.Label16.Text := SQLQuery.FieldByName('POPIS').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT * from phs_orgur3 WHERE KOD = ' +
    HospKniha.Label18.Text);
  SQLQuery.OpenOrExecute;
  HospKniha.Label18.Text := SQLQuery.FieldByName('POPIS').AsString;
  SQLQuery.Close;

  DBConnection.Params.Values['Database'] := DBPath + '/ciselniky.s3db';

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT POPIS from cis_leob WHERE Kod = ' +
    HospKniha.Label2.Text);
  SQLQuery.OpenOrExecute;
  HospKniha.Label2.Text := SQLQuery.FieldByName('POPIS').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT POPIS from zvl_stat WHERE KOD = ' +
    HospKniha.Label6.Text);
  SQLQuery.OpenOrExecute;
  HospKniha.Label6.Text := SQLQuery.FieldByName('POPIS').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT Popis from orp WHERE Kod = ' +
    HospKniha.Label40.Text);
  SQLQuery.OpenOrExecute;
  HospKniha.Label40.Text := SQLQuery.FieldByName('POPIS').AsString;
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT POPIS from kategori WHERE Kod = ' +
    HospKniha.Label4.Text);
  SQLQuery.OpenOrExecute;
  HospKniha.Label4.Text := SplitString(SQLQuery.FieldByName('POPIS')
    .AsString, '-')[0];
  SQLQuery.Close;

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT POPIS from ku6 WHERE KOD = ' +
    HospKniha.Label46.Text);
  SQLQuery.OpenOrExecute;
  HospKniha.Label46.Text := SQLQuery.FieldByName('POPIS').AsString;
  SQLQuery.Close;

  DBConnection.Params.Values['Database'] := DBPath + '/LHC_' + LHC + '_' + rok
    + '.s3db';

  HospKniha.Show;
end;

// zobrazeni hosp.knihy
procedure TForm2.Button3Click(Sender: TObject);
var
  LHC, rok: String;
begin
  if (ComboBox1.Items.Count > 0 AND ComboBox2.Items.Count AND
    ComboBox3.Items.Count AND ComboBox4.Items.Count) then
  begin
    LHC := SplitString(ListBox1.Items[ListBox1.ItemIndex], ' ')[0];
    rok := SplitString(SplitString(ListBox1.Items[ListBox1.ItemIndex], '(')
      [1], '-')[0];

    zobrazHK(LHC, rok, ComboBox1.Items[ComboBox1.ItemIndex],
      ComboBox2.Items[ComboBox2.ItemIndex],
      ComboBox3.Items[ComboBox3.ItemIndex],
      ComboBox4.Items[ComboBox4.ItemIndex],
      ComboBox6.Items[ComboBox6.ItemIndex]);
  end;
end;

// close button
procedure TForm2.Button4Click(Sender: TObject);
begin
  MainActivity.finish;
end;

// zmena oddeleni
procedure TForm2.ComboBox1Change(Sender: TObject);
var
  oddeleni: String;
begin
  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from oddeleni WHERE ODD = ' + ComboBox1.Items
    [ComboBox1.ItemIndex]);
  SQLQuery.OpenOrExecute;
  oddeleni := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  firstODD := oddeleni;
  LoadDIL(oddeleni);
  LoadPOR(firstDIL);
  LoadPS(firstPOR);
  LoadEtaz(firstPS);
end;

// zmena dilce
procedure TForm2.ComboBox2Change(Sender: TObject);
var
  dilec: String;
begin

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from dilec WHERE DIL = "' + ComboBox2.Items
    [ComboBox2.ItemIndex] + '" AND VAZBA = ' + firstODD);
  SQLQuery.OpenOrExecute;
  dilec := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  firstDIL := dilec;
  LoadPOR(dilec);
  LoadPS(firstPOR);
  LoadEtaz(firstPS);
end;

// zmena porostu
procedure TForm2.ComboBox3Change(Sender: TObject);
var
  porost: String;
begin

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from porost WHERE POR = "' + ComboBox3.Items
    [ComboBox3.ItemIndex] + '" AND VAZBA = ' + firstDIL);
  SQLQuery.OpenOrExecute;
  porost := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  firstPOR := porost;
  LoadPS(porost);
  LoadEtaz(firstPS);
end;

// zmena skupiny
procedure TForm2.ComboBox4Change(Sender: TObject);
var
  skupina: String;
begin

  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('SELECT ID from ps WHERE PSK = "' + ComboBox4.Items
    [ComboBox4.ItemIndex] + '" AND VAZBA = ' + firstPOR);
  SQLQuery.OpenOrExecute;
  skupina := SQLQuery.FieldByName('ID').AsString;
  SQLQuery.Close;

  firstPS := skupina;
  LoadEtaz(skupina);
end;

// init
procedure TForm2.FormCreate(Sender: TObject);
var
  HomePath: String;
  RootNode, CurNode: IXMLNODE;
  XMLDocument: IXMLDocument;
  // nacteni configu
begin
  HomePath := TPath.GetHomePath + '/miniHeletaxConf.xml';
  if TFile.Exists(HomePath) then
  begin
    XMLDocument := LoadXMLDocument(HomePath);
    XMLDocument.Active := true;
    RootNode := XMLDocument.DocumentElement;
    CurNode := RootNode.ChildNodes['DBPath'];
    DBPath := CurNode.Text;
    XMLDocument.Active := false;
    Application.ProcessMessages;
    LoadLHC(DBPath);
  end
  // pripadne default
  else
  begin
    DBPath := '/';
    Application.ProcessMessages;
    LoadLHC(DBPath);
  end;

end;

// vyber LHC
procedure TForm2.ListBox1ItemClick(const Sender: TCustomListBox;
  const AItem: TListBoxItem);
var
  LHC, rok: String;
  first: boolean;

begin

  LHC := SplitString(ListBox1.Items[ListBox1.ItemIndex], ' ')[0];
  rok := SplitString(SplitString(ListBox1.Items[ListBox1.ItemIndex], '(')
    [1], '-')[0];
  // nacitani comboboxu
  AniIndicator1.Visible := true;
  AniIndicator1.Enabled := true;
  Application.ProcessMessages;
  DBConnection.Params.Values['Database'] := DBPath + '/LHC_' + LHC + '_' + rok
    + '.s3db';
  ComboBox1.Items.Clear;
  ComboBox2.Items.Clear;
  ComboBox3.Items.Clear;
  ComboBox4.Items.Clear;
  ComboBox6.Items.Clear;
  LoadODD;
  LoadDIL(firstODD);
  LoadPOR(firstDIL);
  LoadPS(firstPOR);
  LoadEtaz(firstPS);
  Application.ProcessMessages;

end;

// nacteni comba se oddelenima
procedure TForm2.LoadODD;
var
  first: boolean;
begin
  AniIndicator1.Visible := true;
  AniIndicator1.Enabled := true;
  first := false;
  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('Select ODD, ID from oddeleni');
  SQLQuery.OpenOrExecute;
  ComboBox1.Items.Clear;

  while NOT SQLQuery.Eof do
  begin
    if not first then
    begin
      firstODD := SQLQuery.FieldByName('ID').AsString;
      first := true;

    end;
    ComboBox1.Items.Add(SQLQuery.FieldByName('ODD').AsString.Trim);
    SQLQuery.Next;
    Application.ProcessMessages;
  end;
  ComboBox1.ItemIndex := 0;
  SQLQuery.Close;
  first := false;
  AniIndicator1.Visible := false;
  AniIndicator1.Enabled := false;
  Application.ProcessMessages;
end;

// nacteni comba se dilcema
procedure TForm2.LoadDIL(oddeleni: String);
var
  first: boolean;
begin
  AniIndicator1.Visible := true;
  AniIndicator1.Enabled := true;
  first := false;
  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('Select DIL, ID from dilec WHERE vazba = ' + oddeleni);
  SQLQuery.OpenOrExecute;
  ComboBox2.Items.Clear;

  while NOT SQLQuery.Eof do
  begin
    if not first then
    begin
      firstDIL := SQLQuery.FieldByName('ID').AsString;
      first := true;

    end;
    ComboBox2.Items.Add(SQLQuery.FieldByName('DIL').AsString.Trim);
    SQLQuery.Next;
    Application.ProcessMessages;
  end;
  ComboBox2.ItemIndex := 0;
  SQLQuery.Close;
  first := false;
  AniIndicator1.Visible := false;
  AniIndicator1.Enabled := false;
  Application.ProcessMessages;
end;

// nacteni comba se porostama
procedure TForm2.LoadPOR(dilec: String);
var
  first: boolean;
begin
  AniIndicator1.Visible := true;
  AniIndicator1.Enabled := true;
  first := false;
  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('Select POR, ID from porost WHERE vazba = ' + dilec);
  SQLQuery.OpenOrExecute;
  ComboBox3.Items.Clear;

  while NOT SQLQuery.Eof do
  begin
    if not first then
    begin
      firstPOR := SQLQuery.FieldByName('ID').AsString;
      first := true;

    end;
    ComboBox3.Items.Add(SQLQuery.FieldByName('POR').AsString.Trim);
    SQLQuery.Next;
    Application.ProcessMessages;
  end;
  ComboBox3.ItemIndex := 0;
  SQLQuery.Close;
  first := false;
  AniIndicator1.Visible := false;
  AniIndicator1.Enabled := false;
  Application.ProcessMessages;

end;

// nacteni comba se skupinama
procedure TForm2.LoadPS(porost: String);
var
  first: boolean;
begin
  AniIndicator1.Visible := true;
  AniIndicator1.Enabled := true;
  first := false;
  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('Select PSK, ID from ps WHERE vazba = ' + porost);
  SQLQuery.OpenOrExecute;
  ComboBox4.Items.Clear;

  while NOT SQLQuery.Eof do
  begin
    if not first then
    begin
      firstPS := SQLQuery.FieldByName('ID').AsString;
      first := true;

    end;
    ComboBox4.Items.Add(SQLQuery.FieldByName('PSK').AsString.Trim);
    SQLQuery.Next;
    Application.ProcessMessages;
  end;
  ComboBox4.ItemIndex := 0;
  SQLQuery.Close;
  first := false;
  AniIndicator1.Visible := false;
  AniIndicator1.Enabled := false;
  Application.ProcessMessages;
end;

procedure TForm2.LoadEtaz(skupina: String);
begin

  AniIndicator1.Visible := true;
  AniIndicator1.Enabled := true;
  SQLQuery.SQL.Clear;
  SQLQuery.SQL.Add('Select ETAZ, ID from etaz WHERE vazba = ' + skupina);
  SQLQuery.OpenOrExecute;
  ComboBox6.Items.Clear;

  while NOT SQLQuery.Eof do
  begin
    ComboBox6.Items.Add(SQLQuery.FieldByName('ETAZ').AsString.Trim);
    SQLQuery.Next;
    Application.ProcessMessages;
  end;
  ComboBox6.ItemIndex := 0;
  SQLQuery.Close;

  AniIndicator1.Visible := false;
  AniIndicator1.Enabled := false;
  Application.ProcessMessages;
end;

// nahrani seznamu LHC
procedure TForm2.LoadLHC(DataPath: String);
var
  SPath: String;
  Path: TPath;
  Kod: String;
  Nazev: String;
  Datum: String;
  Datum2: String;
begin
  ListBox1.Items.Clear;
  Label2.Text := DataPath;
  AniIndicator1.Visible := true;
  AniIndicator1.Enabled := true;
  Application.ProcessMessages;
  for SPath in TDirectory.GetFiles(DataPath) do
  begin
    if Path.GetFileName(SPath).StartsWith('LHC') AND Path.GetExtension(SPath)
      .Equals('.s3db') then
    begin
      DBConnection.Params.Values['Database'] := SPath;
      SQLQuery.SQL.Clear;
      SQLQuery.SQL.Add('Select * from lhc');
      SQLQuery.OpenOrExecute;
      while NOT SQLQuery.Eof do
      begin
        Kod := SplitString(SQLQuery.FieldByName('LHC_KOD').AsString, ',')[0];
        Nazev := SQLQuery.FieldByName('LHC_NAZ').AsString;
        Datum := SQLQuery.FieldByName('LHP_OD').AsString;
        Datum2 := SQLQuery.FieldByName('LHP_DO').AsString;
        ListBox1.Items.Add(Kod + ' - ' + Nazev + ' (' +
          SplitString(SplitString(Datum, '.')[2], ' ')[0] + '-' +
          SplitString(SplitString(Datum2, '.')[2], ' ')[0] + ')');
        SQLQuery.Next;
        Application.ProcessMessages;
      end;
      SQLQuery.Close;

    end;
  end;
  AniIndicator1.Visible := false;
  AniIndicator1.Enabled := false;
  Application.ProcessMessages;

end;

end.
